
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Nov 29 18:42:53 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version ODRM_TLK_ATP_main.c#1:csrc:1
   *  \author Sagitb
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */


/***** Include Files **************/
#include "DX_VOS_BaseTypes.h"
#include "MW_ATP_defines.h"
#include "MW_ATP_define_flags.h"
#include "MW_ATP_UTIL_funcs.h"


#include "ODRM_SecROHandling_data.h"
/******** Defines ************/
extern DxError_t ODRM_SecROHandling_ATP_menu(void);

/*****************************************************************************
* Function Name:                                                           
*  main      
*  
* Inputs:
*  None
*
* Outputs: 
*  None                                    
*
* Description:                                                                 
*  This function runs the ATP menu
*  
******************************************************************************/
#if ODRM_SEC_RO_QA_ATP_TST
 int main(int argc, char *argv[])
#else 
 DxStatus ODRM_SecROHandling_ATP_main (int argc, char *argv[])
#endif  /* ODRM_TLK_QA_ATP_TST */
 {
    /********* TST Variables Definitions ************/
    DxError_t           TST_Error = DX_SUCCESS;
    
    /* Handle Command Line Arguments */
    TST_Error = MW_ATP_UTIL_ParseArgs(argc,argv);
    TST_ATP_CHECK_ERROR_RETURN(TST_Error,
                                             "MW_ATP_UTIL_ParseArgs",
                                             "!!!!!!!!!",
                                             "!!!!!!!!!");

    /* Init CRYS */
    TST_Error = MW_ATP_UTIL_Init_CRYS();
    TST_ATP_CHECK_ERROR_RETURN(TST_Error,
                                             "MW_ATP_UTIL_Init_CRYS",
                                             "!!!!!!!!!",
                                             "!!!!!!!!!");

	

	
    
    /* Start TLK_ODRM_ATP and its Menu */
    TST_Error = ODRM_SecROHandling_ATP_menu();
EXIT_ON_ERROR:
    
    return TST_Error;
 }



